CREATE OR REPLACE PACKAGE TBICDS.PCK_USER_CALENDAR
AUTHID CURRENT_USER 
IS

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  PROCEDURE GetAllEventsRS(
      pi_vSessionID       IN VARCHAR2,
      pi_vSessionClientIP IN VARCHAR2,
      pi_nUserID          IN NUMBER,
      rs OUT PCK_COMMON.refCursor,
      po_nStatusCode OUT NUMBER,
      po_vStatusComment OUT VARCHAR2);
      
  PROCEDURE UpdateEvent(
      pi_vSessionID       IN VARCHAR2,
      pi_vSessionClientIP IN VARCHAR2,
      pi_nUserID          IN NUMBER,
      pi_nEventID         IN NUMBER,
      pi_nCalendarID      IN NUMBER,
      pi_vTitle           IN VARCHAR2,
      pi_vStartDate       IN VARCHAR2,
      pi_vEndDate         IN VARCHAR2,
      pi_vLocation        IN VARCHAR2,
      pi_vNotes           IN VARCHAR2,
      pi_vReminder        IN VARCHAR2,
      pi_vUrl             IN VARCHAR2,
      pi_nAllDay          IN NUMBER,
      po_nStatusCode OUT NUMBER,
      po_vStatusComment OUT VARCHAR2);
      
  PROCEDURE InsertEvent(
      pi_vSessionID       IN VARCHAR2,
      pi_vSessionClientIP IN VARCHAR2,
      pi_nUserID          IN NUMBER,
      --pi_nEventID         IN NUMBER,
      pi_nCalendarID      IN NUMBER,
      pi_vTitle           IN VARCHAR2,
      pi_vStartDate       IN VARCHAR2,
      pi_vEndDate         IN VARCHAR2,
      pi_vLocation        IN VARCHAR2,
      pi_vNotes           IN VARCHAR2,
      pi_vReminder        IN VARCHAR2,
      pi_vUrl             IN VARCHAR2,
      pi_nAllDay          IN NUMBER,
      po_nStatusCode OUT NUMBER,
      po_vStatusComment OUT VARCHAR2);
      
  PROCEDURE GetAllCalendarsRS(
      pi_vSessionID       IN VARCHAR2,
      pi_vSessionClientIP IN VARCHAR2,
      pi_nUserID          IN NUMBER,
      rs OUT PCK_COMMON.refCursor,
      po_nStatusCode OUT NUMBER,
      po_vStatusComment OUT VARCHAR2);
      
END PCK_USER_CALENDAR;
/

